VERSION 5.00
Begin VB.Form FrmReadCards 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Read Cards"
   ClientHeight    =   5295
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   8130
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5295
   ScaleWidth      =   8130
   ShowInTaskbar   =   0   'False
   Begin VB.Timer TmrMain 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   7440
      Top             =   4800
   End
   Begin VB.Label LblResult 
      BeginProperty Font 
         Name            =   "Courier"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4335
      Left            =   120
      TabIndex        =   1
      Top             =   840
      Width           =   7815
   End
   Begin VB.Label LblStatus 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   7815
   End
End
Attribute VB_Name = "FrmReadCards"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Sub Form_Load()
    InitUSB
    TmrMain.Enabled = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    TmrMain.Enabled = False
    CloseDevice
    CloseUSB
End Sub

Private Sub TmrMain_Timer()
'This timer coordinates the card reading and data displaying

    Dim StartTime As Date
    
'Check if any fatal errors have occured
    If FatalError <> "" Then
        LblStatus.Caption = "Fatal Error - " & FatalError
        Exit Sub
    End If
    

    If HidDevice = INVALID_HANDLE_VALUE Then
'The device hasn't been detected yet
        LblStatus.Caption = "Attach device..."
'Attempt to detect device
        DetectDevice
        If HidDevice <> INVALID_HANDLE_VALUE Then
'A Mag-Tek device has been detected
            If DeviceAttributes.ProductID = HIDMSRVendDefProdID Or _
                DeviceAttributes.ProductID = HIDMSRVendDefMagnePrintProdID Or _
                DeviceAttributes.ProductID = InsertRdrProdID Then
'The correct USB swipe reader for this application has been detected so
'start the card reading process.
                InitRead
            Else
'The wrong Mag-Tek device has been detected.
                FatalError = "Incompatible device attached"
                If DeviceAttributes.ProductID = HIDMSRKeyBoardEmulProdID Then
'A Mag-Tek keyboard emulation MSR has been detected.
                    MsgBox ("Incompatible device.  Use Notepad application to read cards for this device.")
                Else
                    MsgBox ("Incompatible device.")
                End If
            End If
        End If
    Else
'The correct device has been detected.
        LblStatus.Caption = "Swipe card..."
'See if a card has been swiped.
        If ReadInputRpt() = True Then
'A card has been swiped.
'Clear any old card data from the display.
            LblStatus.Caption = "Processing data..."
            LblResult.Caption = ""
            StartTime = Timer
            Do While Timer < StartTime + 0.1 ' wait 100ms for data clear to take affect
               DoEvents
            Loop
'Extract the card data from the HID report
            If GetMSRResults() = True Then
'Display the card data
                DisplayMSRResults
            End If
        End If
    End If
 End Sub

Public Sub DisplayMSRResults()
'Displays magnetic stripe read results

Dim SwipeDirStr As String
Dim MagnePrintStsStr As String
Dim SequenceCounterStr As String

    If DeviceAttributes.ProductID = InsertRdrProdID Then
        If (CardSts And CS_CARD_INSERTED) = CS_CARD_INSERTED Then
            SwipeDirStr = ", Swipe Direction = Insert"
        Else
            SwipeDirStr = ", Swipe Direction = Withdrawal"
        End If
    Else
        SwipeDirStr = ""
    End If
    
    If (Tk1DcdSts And DS_ERROR) = DS_ERROR Then
        Tk1DataStr = "Error"
    End If
    If (Tk2DcdSts And DS_ERROR) = DS_ERROR Then
        Tk2DataStr = "Error"
    End If
    If (Tk3DcdSts And DS_ERROR) = DS_ERROR Then
        Tk3DataStr = "Error"
    End If
        
    If Tk1Len > 55 Then
        Tk1DataStr = Left(Tk1DataStr, 55) & vbCrLf & Mid(Tk1DataStr, 56)
    End If
    
    If Tk2Len > 55 Then
        Tk2DataStr = Left(Tk2DataStr, 55) & vbCrLf & Mid(Tk2DataStr, 56)
    End If
    
    If Tk3Len > 55 Then
        Tk3DataStr = Left(Tk3DataStr, 55) & vbCrLf & Mid(Tk3DataStr, 56)
    End If
    
    If DeviceAttributes.ProductID = HIDMSRVendDefMagnePrintProdID Then
        MagnePrintDataStr = "MagnePrint Data (hex) = " & MagnePrintDataStr
        MagnePrintStsStr = "MagnePrint Status (hex) = " & LongToHex(MagnePrintSts)
        DeviceSerialNumberDataStr = "Device Serial Number = " & DeviceSerialNumberDataStr
        SequenceCounterStr = "Sequence Counter = " & Str(SequenceCounter)
    Else
        MagnePrintDataStr = ""
        MagnePrintStsStr = ""
        DeviceSerialNumberDataStr = ""
        SequenceCounterStr = ""
    End If
    
    LblResult.Caption = _
        "Card Encode Type = " & GetCardEncodeTypeStr(CrdEcdTyp) & SwipeDirStr & vbCrLf & vbCrLf & _
        "Track 1 = " & Tk1DataStr & vbCrLf & vbCrLf & _
        "Track 2 = " & Tk2DataStr & vbCrLf & vbCrLf & _
        "Track 3 = " & Tk3DataStr & vbCrLf & vbCrLf & vbCrLf & _
        MagnePrintStsStr & vbCrLf & vbCrLf & _
        MagnePrintDataStr & vbCrLf & vbCrLf & _
        DeviceSerialNumberDataStr & vbCrLf & vbCrLf & _
        SequenceCounterStr
End Sub
